% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMVariogramAnalyser.R
\name{getLogLogOmnidirectionalSlopeGraph}
\alias{getLogLogOmnidirectionalSlopeGraph}
\title{Get the graph of the Log Log omnidiretction variogram
\code{getLogLogOmnidirectionalSlopeGraph} returns Get the graph of the Log Log omnidirectional variogram}
\usage{
getLogLogOmnidirectionalSlopeGraph(AFMImageAnalyser,
  withFratcalSlope = FALSE)
}
\arguments{
\item{AFMImageAnalyser}{an \code{\link{AFMImageAnalyser}}}

\item{withFratcalSlope}{a boolean to indicate if the graph should contain a line representating the slope for the calculation of the fractal index and topothesy}
}
\value{
a ggplot2 graph
}
\description{
Get the graph of the Log Log omnidiretction variogram
\code{getLogLogOmnidirectionalSlopeGraph} returns Get the graph of the Log Log omnidirectional variogram
}
\examples{
\dontrun{
library(AFM)
library(ggplot2)

data(AFMImageOfRegularPeaks)

AFMImageAnalyser = new("AFMImageAnalyser",
         fullfilename="/home/ubuntu/AFMImageOfRegularPeaks-Analyser.txt")
variogramAnalysis<-AFMImageVariogramAnalysis(sampleFitPercentage=3.43/100)
AFMImageAnalyser@variogramAnalysis<-variogramAnalysis
AFMImageAnalyser@variogramAnalysis@omnidirectionalVariogram<-
     calculateOmnidirectionalVariogram(AFMImage= AFMImageOfRegularPeaks, 
                                       AFMImageVariogramAnalysis= variogramAnalysis)
p<-getLogLogOmnidirectionalSlopeGraph(AFMImageAnalyser,  withFratcalSlope=TRUE)
p
} 
}
\author{
M.Beauvais
}
