% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Raw_Utils.R
\name{check_columns}
\alias{check_columns}
\title{Check if the primary accelerometer file is formatted correctly}
\usage{
check_columns(file, skip, ...)
}
\arguments{
\item{file}{A character scalar giving path to primary accelerometer file}

\item{skip}{Header length: Number of rows to skip when reading the file}

\item{...}{Arguments passed to \code{\link{read.csv}}}
}
\description{
\code{check_columns} returns a logical scalar indicating whether there is a
 formatting issue with the file passed as the argument. A value of TRUE
 indicates the test has passed, whereas FALSE indicates an issue.
}
\examples{
raw_file <-
    system.file("extdata",
    "exampleRAW.csv",
    package = "AGread")

col_check <- check_columns(raw_file, skip = 10)
head(col_check)

}
