% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Counts_Utils.R
\name{AG_meta}
\alias{AG_meta}
\alias{value_check}
\alias{meta_format}
\title{Extract meta-data from file header}
\usage{
AG_meta(
  file,
  verbose = FALSE,
  header_timestamp_format = "\%m/\%d/\%Y \%H:\%M:\%S"
)

value_check(values)

meta_format(x)
}
\arguments{
\item{file}{A character scalar giving path to an automatically-generated csv
file with count values}

\item{verbose}{A logical scalar: Print processing updates?}

\item{header_timestamp_format}{character. Space delimited format of the date
and time in the file header (default is \code{\%m/\%d/\%Y \%H:\%M:\%S})}

\item{values}{list of meta values to check for completeness}

\item{x}{string to format (one line of input from the data file)}
}
\value{
A list with metadata information
}
\description{
Extract meta-data from file header
}
\examples{
counts_file <- system.file(
  "extdata", "example1sec.csv", package = "AGread"
)
AGread::AG_meta(counts_file)

}
\keyword{internal}
