% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispvar_function.R
\name{dispvar}
\alias{dispvar}
\title{Descriptive: Boxplot with standardized data}
\usage{
dispvar(
  data,
  trat = NULL,
  theme = theme_bw(),
  ylab = "Standard mean",
  xlab = "Variable",
  family = "serif",
  textsize = 12,
  fill = "lightblue"
)
}
\arguments{
\item{data}{data.frame containing the response of the experiment.}

\item{trat}{Numerical or complex vector with treatments}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{family}{Font family}

\item{textsize}{Font size}

\item{fill}{Defines chart color}
}
\value{
Returns a chart of boxes with standardized data
}
\description{
It makes a graph with the variables and/or treatments with the standardized data.
}
\examples{
library(AgroR)
data("pomegranate")
dispvar(pomegranate[,-1])
trat=pomegranate$trat
dispvar(pomegranate[,-1], trat)
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Descriptive}
\keyword{Experimental}
