% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqiColors.R
\name{aqiColors}
\alias{aqiColors}
\title{Generate AQI colors}
\usage{
aqiColors(
  x,
  pollutant = c("PM2.5", "AQI", "CO", "NO", "OZONE", "PM10", "SO2"),
  palette = c("EPA", "subdued", "deuteranopia"),
  na.color = NA,
  NAAQS = c("PM2.5_2024", "PM2.5")
)
}
\arguments{
\item{x}{Vector or matrix of PM2.5 values or an \emph{mts_monitor} object.}

\item{pollutant}{EPA AQS criteria pollutant.}

\item{palette}{Named color palette to use for AQI categories.}

\item{na.color}{Color assigned to missing values.}

\item{NAAQS}{Version of NAAQS levels to use. See Note.}
}
\value{
A vector or matrix of AQI colors to be used in maps and plots.
}
\description{
This function uses the \code{leaflet::colorBin()} function to return a
vector or matrix of colors derived from data values.
}
\note{
On February 7, 2024, EPA strengthened the National Ambient Air Quality
Standards for Particulate Matter (PM NAAQS) to protect millions of Americans
from harmful and costly health impacts, such as heart attacks and premature
death. Particle or soot pollution is one of the most dangerous forms of air
pollution, and an extensive body of science links it to a range of serious
and sometimes deadly illnesses. EPA is setting the level of the primary
(health-based) annual PM2.5 standard at 9.0 micrograms per cubic meter to
provide increased public health protection, consistent with the available
health science.
See \href{https://www.epa.gov/pm-pollution/final-reconsideration-national-ambient-air-quality-standards-particulate-matter-pm}{PM NAAQS update}.
}
\examples{
library(AirMonitor)

# Fancy plot based on pm2.5 values
pm2.5 <- Carmel_Valley$data[,2]
Carmel_Valley \%>\%
  monitor_timeseriesPlot(
    shadedNight = TRUE,
    pch = 16,
    cex = pmax(pm2.5 / 100, 0.5),
    col = aqiColors(pm2.5),
    opacity = 0.8
  )
}
\seealso{
\code{\link{aqiCategories}}
}
