% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_rescaleTraits}
\alias{SimParam_rescaleTraits}
\title{Rescale traits}
\arguments{
\item{mean}{a vector of new trait means}

\item{var}{a vector of new trait variances}

\item{varEnv}{a vector of new environmental variances}

\item{varGxE}{a vector of new GxE variances}

\item{useVarA}{tune according to additive genetic variance if true}
}
\description{
Linearly scales all traits to achieve desired 
values of means and variances in the founder population.
}
\note{
By default the founder population is the population used to 
initalize the SimParam object. This population can be changed using 
the switchFounderPop function in the SimParam object 
(see \code{\link{SimParam_switchFounderPop}}). You must run 
\code{\link{resetPop}} on existing populations to obtain the new trait values.
}
\section{Usage}{
 SP$rescaleTraits(mean = 0, var = 1, relAA = 1e-6,
varEnv = 0, varGxE = 1e-6, useVarA = TRUE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
meanG(pop)

#Change mean to 1
SP$rescaleTraits(mean=1)
#Run resetPop for change to take effect
pop = resetPop(pop, simParam=SP) 
meanG(pop)

}
