% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullMarkerHaplo}
\alias{pullMarkerHaplo}
\title{Pull marker haplotypes}
\usage{
pullMarkerHaplo(pop, markers, haplo = "all", asRaw = FALSE, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{RawPop-class}} or
\code{\link{MapPop-class}}}

\item{markers}{a character vector. Indicates the
names of the loci to be retrieved}

\item{haplo}{either "all" for all haplotypes or an integer
for a single set of haplotypes. Use a value of 1 for female
haplotypes and a value of 2 for male haplotypes in diploids.}

\item{asRaw}{return in raw (byte) format}

\item{simParam}{an object of \code{\link{SimParam}}, not 
used if pop is \code{\link{MapPop-class}}}
}
\value{
Returns a matrix of genotypes.
}
\description{
Retrieves haplotype data for user
specified loci
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$addSnpChip(5)
SP$setTrackRec(TRUE)

#Create population
pop = newPop(founderPop, simParam=SP)

#Pull haplotype data for first two markers on chromosome one.
#Marker name is consistent with default naming in AlphaSimR.
pullMarkerHaplo(pop, markers=c("1_1","1_2"), simParam=SP)

}
