% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getCAI}
\alias{getCAI}
\title{Calculate the Codon Adaptation Index}
\usage{
getCAI(referenceGenome, testGenome)
}
\arguments{
\item{referenceGenome}{A genome object initialized with \code{\link{initializeGenomeObject}}.
Serves as reference set to calculate the necessary codon weights.}

\item{testGenome}{A genome object initialized with \code{\link{initializeGenomeObject}}.
The genome for which the CAI is supposed to be calculated}
}
\value{
Returns a named vector with the CAI for each gene
}
\description{
\code{getCAI} returns the Codon Adaptation Index for a 
genome based on a provided reference.
}
\examples{

genome_file1 <- system.file("extdata", "more_genes.fasta", package = "AnaCoDa")
genome_file2 <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

## reading genome
referenceGenome <- initializeGenomeObject(file = genome_file1)
testGenome <- initializeGenomeObject(file = genome_file2)

cai <- getCAI(referenceGenome, testGenome)

}
