% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_plot.R
\name{dens_plot}
\alias{dens_plot}
\title{Numerical Variables Density Plots}
\usage{
dens_plot(
  data,
  fill = "skyblue",
  color = "black",
  alpha = 0.7,
  subplot = FALSE,
  nrow = 2,
  margin = 0.1,
  html = FALSE
)
}
\arguments{
\item{data}{The input data frame containing numerical variables.}

\item{fill}{The fill color of the density plot (default: "skyblue").}

\item{color}{The line color of the density plot (default: "black").}

\item{alpha}{The transparency of the density plot (default: 0.7).}

\item{subplot}{A logical argument (default: FALSE) indicating whether to create subplots.}

\item{nrow}{Number of rows for subplots (if subplot is TRUE, default: 2).}

\item{margin}{Margin for subplots (if subplot is TRUE, default: 0.1).}

\item{html}{Whether the output should be in HTML format,used when knitting into HTML. Default is FALSE.}
}
\value{
A list of density plots.
}
\description{
This function generates density plots for all numerical variables in the input data frame.
It offers a vivid and effective visual summary of the distribution of each numerical variable,
helping in a quick understanding of their central tendency, spread, and shape.
}
\examples{
data(mtcars)
dens_plot(mtcars)

}
