% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhasePlot}
\alias{MultiPhasePlot}
\title{ Plot of the marginal posterior densities of several groups}
\usage{
MultiPhasePlot(data, position_minimum, position_maximum = position_minimum+1,
  level = 0.95,  title = "Characterisation of several groups", colors = NULL, 
  exportFile = NULL, exportFormat = "PNG")
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm. The MCMC samples should be in calendar year (BC/AD). }
  \item{position_minimum}{numeric vector containing the column number corresponding to the minimum of the dates included in each group}
  \item{position_maximum}{numeric vector containing the column number corresponding to the maximum of the dates included in each group. By default, position_maximum = position_minimum + 1. }
  \item{level}{probability corresponding to the level of confidence}
  \item{title}{title of the graph}
   \item{colors}{numeric vector of colors for each group of dates}
  \item{exportFile}{the name of the file to be saved. If NULL then no graph is saved}
  \item{exportFormat}{the format of the export file : SVG or PNG}
}
\description{
  Draws a plot with the marginal posterior densities of the minimum and the maximum of the dates included in each group. No temporal order between phases is required. The result is given in calendar year (in format BC/AD).
}
\value{
  Draws a plot with the marginal posterior densities of the minimum and the maximum of the dates included in each group and adds the time range of each group.
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  
  # List of the name of the groups 
  names(Phases)
  
  # Stipulating position_maximum
  MultiPhasePlot(Phases, c(4,2), c(5,3), title = "Succession of phase 1 and phase 2")
  
  # In this case, equivalent to 
  MultiPhasePlot(Phases, c(4,2), title = "Succession of phase 1 and phase 2", colors = c(3,4))
  
  # Export 
  # MultiPhasePlot(Phases, c(4,2), exportFile = "MultiPhasePlot", exportFormat = "PNG")
}
\keyword{ phase time range }
\keyword{ marginal posterior density }
