\name{KADatesOxcal}
\alias{KADatesOxcal}
\docType{data}
\title{ 
Ksar Akil chronology build with Oxcal software
}
\description{
MCMC samples from the posterior distribution of dates included in the Ksar Akil chronology build with Oxcal software. See Bosch, M. et al. (2015) for more details. The MCMC samples are in calendar year (BC/AD).
}
\usage{data(KADatesOxcal)}

\format{
 A data frame with 10000 observations on the following 28 variables contained in the outputs generated by Oxcal. 
  \describe{
    \item{\code{Pass}}{a numeric vector corresponding to iteration number}
    
    \item{\code{Ethelruda}}{a numeric vector containing the output of the MCMC algorithm for . }
    
    \item{\code{start.dated.IUP}}{a numeric vector containing the output of the MCMC algorithm for the date of the start of phase IUP. }
    \item{\code{GrA.53000}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.53000.}
    \item{\code{end.dated.IUP}}{a numeric vector containing the output of the MCMC algorithm for the date of the end of phase IUP.}
    
    \item{\code{start.Ahmarian}}{a numeric vector containing the output of the MCMC algorithm for the date of the start of phase Ahmarian.}
    \item{\code{GrA.57597}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57597. }
    \item{\code{GrA.53004}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.53004.}
    \item{\code{GrA.57542}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57542.}
    \item{\code{GrA.54846}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.54846.}
    \item{\code{GrA.57603}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57603. }
    \item{\code{GrA.57602}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57602.}
    \item{\code{GrA.53001}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.53001.}
    
    \item{\code{Egbert}}{a numeric vector containing the output of the MCMC algorithm for the date Egbert.}
    
    \item{\code{GrA.54847}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.54847. }
    \item{\code{GrA.57599}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57599.}
    \item{\code{GrA.57598}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57598.}
    \item{\code{GrA.57544}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57544.}
    \item{\code{end.Ahmarian}}{a numeric vector containing the output of the MCMC algorithm for the date of the end of phase Ahmarian.}
    
    \item{\code{start.UP}}{a numeric vector containing the output of the MCMC algorithm for the date of the start of phase UP.}
    \item{\code{GrA.57545}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.57545. }
    \item{\code{GrA.53006}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.53006.}
    \item{\code{GrA.54848}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.54848.}
    \item{\code{end.UP}}{a numeric vector containing the output of the MCMC algorithm for the date of the end of phase UP.}
     
    \item{\code{start.EPI}}{a numeric vector containing the output of the MCMC algorithm for the date of the start of phase EPI.}
    \item{\code{GrA.53005}}{a numeric vector containing the output of the MCMC algorithm for the date GrA.53005. }
    \item{\code{end.EPI}}{a numeric vector containing the output of the MCMC algorithm for the date of the end of phase EPI.}
  }
}

\source{
Bosch, M. et al. (2015) New chronology for Ksar Akil (Lebanon) supports Levantine route of modern human dispersal into Europe. Proceedings of the National Academy of Sciences, 112, 7683--6.
}
\references{
Bronk Ramsey, C. (2009) Bayesian analysis of radiocarbon dates. Radiocarbon, 51(1), 337-360.

Bronk Ramsey, C. (2016) Oxcal 4.2.
}
\examples{
  ##load data
  data(KADatesOxcal)
}

\keyword{datasets}
\keyword{MCMC output}
\keyword{Oxcal}

\author{
Anne Philippe <Anne.Philippe@univ-nantes.fr> and

Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}