% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempoActivityPlot.R
\name{TempoActivityPlot}
\alias{TempoActivityPlot}
\title{Plot the derivative of the tempo plot Bayesian estimate}
\usage{
TempoActivityPlot(
  data,
  position,
  plot.result = NULL,
  level = 0.95,
  title = "Activity plot",
  subtitle = NULL,
  caption = "ArcheoPhases",
  x.label = "Calendar year",
  y.label = "Activity",
  line.types = c("solid"),
  width = 7,
  height = 7,
  units = "in",
  x.min = NULL,
  x.max = NULL,
  file = NULL,
  x.scale = "calendar",
  elapsed.origin.position = NULL,
  newWindow = TRUE,
  print.data.result = FALSE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{plot.result}{List containing the data to plot, typically the
result of a previous run of \code{TempoActivityPlot()}.}

\item{level}{Probability corresponding to the level of confidence.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{x.label}{Label of the x-axis.}

\item{y.label}{Label of the y-axis.}

\item{line.types}{Type of the lines drawn on the plot.}

\item{width}{Width of the plot in \code{units}.}

\item{height}{Height of the plot in \code{units}.}

\item{units}{Units used to specify \code{width} and \code{height},
one of "in" (default),"cm", or "mm".}

\item{x.min}{Minimum value for x-axis.}

\item{x.max}{Maximum value for x-axis.}

\item{file}{Name of the file to be saved if specified.
If \code{Null}, then no file is saved.}

\item{x.scale}{One of "calendar", "bp", or "elapsed".}

\item{elapsed.origin.position}{If \code{x.scale} is "elapsed", the position
of the column corresponding to the event from which elapsed time is calculated.}

\item{newWindow}{Whether or not the plot is drawn within a new window .}

\item{print.data.result}{If \code{TRUE}, the list containing the data to plot
is returned.}
}
\value{
\code{NULL}, called for its side effects.  It may also return a list
containing the data to plot (if \code{print.data.result = TRUE}). The result
is given in calendar years (BC/AD).
}
\description{
A statistical graphic designed for the archaeological study of rhythms of
the long term that embodies a theory of archaeological evidence for the
occurrence of events
}
\examples{
  data(Events);
  TempoActivityPlot(Events[1:1000, ], c(2:5), print.data.result = FALSE)
  TempoActivityPlot(Events[1:1000, ], c(2:5), print.data.result = FALSE)

}
\references{
Dye, T.S. (2016) Long-term rhythms in the development of Hawaiian social stratification.
Journal of Archaeological Science, 71, 1--9.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
