% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_subscription.R
\docType{class}
\name{az_subscription}
\alias{az_subscription}
\title{Azure subscription class}
\format{An R6 object of class \code{az_subscription}.}
\usage{
az_subscription
}
\description{
Class representing an Azure subscription.
}
\section{Methods}{

\itemize{
\item \code{new(token, id, ...)}: Initialize a subscription object.
\item \code{list_resource_groups()}: Return a list of resource group objects for this subscription.
\item \code{get_resource_group(name)}: Return an object representing an existing resource group.
\item \code{create_resource_group(name, location)}: Create a new resource group in the specified region/location, and return an object representing it.
\item \code{delete_resource_group(name, confirm=TRUE)}: Delete a resource group, after asking for confirmation.
\item \code{resource_group_exists(name)}: Check if a resource group exists.
\item \code{list_resources()}: List all resources deployed under this subscription.
\item \code{list_locations()}: List locations available.
\item \code{get_provider_api_version(provider, type)}: Get the current API version for the given resource provider and type. If no resource type is supplied, returns a vector of API versions, one for each resource type for the given provider. If neither provider nor type is supplied, returns the API versions for all resources and providers.
}
}

\section{Details}{

Generally, the easiest way to create a subscription object is via the \code{get_subscription} or \code{list_subscriptions} methods of the \link{az_rm} class. To create a subscription object in isolation, call the \code{new()} method and supply an Oauth 2.0 token of class \link{AzureToken}, along with the ID of the subscription.
}

\examples{
\dontrun{

# recommended way to retrieve a subscription object
sub <- az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")

# retrieve list of resource group objects under this subscription
sub$list_resource_groups()

# get a resource group
sub$get_resource_group("rgname")

# check if a resource group exists, and if not, create it
rg_exists <- sub$resource_group_exists("rgname")
if(!rg_exists)
    sub$create_resource_group("rgname", location="australiaeast")

# delete a resource group
sub$delete_resource_group("rgname")

# get provider API versions for some resource types
sub$get_provider_api_version("Microsoft.Compute", "virtualMachines")
sub$get_provider_api_version("Microsoft.Storage", "storageAccounts")

}
}
\seealso{
\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-overview}{Azure Resource Manager overview}
}
\keyword{datasets}
