% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_vm_fns.R
\name{rvm}
\alias{rvm}
\alias{dvm}
\title{The univariate von Mises distribution}
\usage{
rvm(n, kappa = 1, mu = 0)

dvm(x, kappa = 1, mu = 0)
}
\arguments{
\item{n}{number of observations. Ignored if at least one of the other parameters have length k > 1, in which
case, all the parameters are recycled to length k to produce k random variates.}

\item{kappa}{vector of concentration (inverse-variance) parameters; \code{kappa} > 0.}

\item{mu}{vector of means.}

\item{x}{vector of angles (in radians) where the densities are to be evaluated.}
}
\value{
\code{dvm} gives the density  and \code{rvm} generates random deviates.
}
\description{
The univariate von Mises distribution
}
\details{
If \code{mu} and \code{kappa} are not specified they assume the default values of \code{0} and \code{1} respectively.

The univariate von Mises distribution has density
\deqn{f(x) = 1/(2\pi I_0 (\kappa)) \exp(\kappa \cos(x - mu))}
where \eqn{I_0 (\kappa)} denotes the modified Bessel function of the first kind with order 0 evaluated at the point \eqn{\kappa}.
}
\examples{

kappa <- 1:3
mu <- 0:2
x <- 1:10
n <- 10


# when x and both parameters are scalars, dvm returns a single density
dvm(x[1], kappa[1], mu[1])

# when x is a vector but both the parameters are scalars, dmv returns a vector of
# densities calculated at each entry of x with the same parameters
dvm(x, kappa[1], mu[1])

# if x is scalar and at least one of the two paraemters is a vector, both parameters are
# recycled to the same length, and dvm returns a vector of with ith element being the
# density evaluated at x with parameter values kappa[i] and mu[i]
dvm(x[1], kappa, mu)

# if x and at least one of the two paraemters is a vector, x and the two parameters are
# recycled to the same length, and dvm returns a vector of with ith element being the
# density at ith element of the (recycled) x with parameter values kappa[i] and mu[i]
dvm(x, kappa, mu)

# when parameters are all scalars, number of observations generated by rvm is n
rvm(n, kappa[1], mu[1])

# when at least one of the two parameters is a vector, both are recycled to the same length,
# n is ignored, and the number of observations generated by rvm is the same as the length of
# the recycled vectors
rvm(n, kappa, mu)

}
