% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{lpdtrace}
\alias{lpdtrace}
\title{Trace and autocorrelation plots of log posterior density or log likelihood from an angmcmc object}
\usage{
lpdtrace(object, chain.no, use.llik = FALSE, plot.autocor = FALSE,
  lag.max = NULL, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{chain.no}{vector of chain numbers whose samples are to be be used.
in the estimation. By default all chains are used.}

\item{use.llik}{logical. Should log likelihood be plotted instead of log posterior? Set
to \code{FALSE} by default.}

\item{plot.autocor}{logical. Should the autocorrelations be plotted as well?}

\item{lag.max}{maximum lag for autocorrelation.  Passed to \link{acf}. Ignored if
\code{plot.autocor = FALSE}.}

\item{...}{unused}
}
\description{
Trace and autocorrelation plots of log posterior density or log likelihood from an angmcmc object
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# log posterior density trace
lpdtrace(fit.vmsin.20)
# log likelihood trace
lpdtrace(fit.vmsin.20, use.llik = TRUE)

}
