% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{rao}
\alias{rao}
\title{Rao quadratic entropy.}
\usage{
rao(comm, tree, distance, raref = 0, runs = 100)
}
\arguments{
\item{comm}{A sites x species matrix, with abundance data.}

\item{tree}{A phylo or hclust object (used only for PD or FD).}

\item{distance}{A dist object representing the phylogenetic or functional distance between species or alternatively a species x traits matrix or data.frame to calculate distances.}

\item{raref}{An integer specifying the number of individuals for rarefaction (individual based).
If raref < 1 no rarefaction is made.
If raref = 1 rarefaction is made by the minimum abundance among all sites.
If raref > 1 rarefaction is made by the abundance indicated.
If not specified, default is 0.}

\item{runs}{Number of resampling runs for rarefaction. If not specified, default is 100.}
}
\value{
A matrix of sites x diversity values (either "Rao" OR "Mean, Median, Min, LowerCL, UpperCL and Max").
}
\description{
Rao quadratic entropy for Phylogenetic or Functional richness.
}
\details{
Rao quadratic entropy (Rao, 1982) measures diversity based on the abundance of species and the dissimilarity between them.
}
\examples{
comm <- matrix(c(0,0,1,1,0,0,100,1,2,0), nrow = 2, ncol = 5, byrow = TRUE)
distance = dist(1:5)
rao(comm)
rao(comm, , distance)
rao(comm, hclust(distance), raref = 1)
}
\references{
Rao, C.R. (1982). Diversity and dissimilarity coefficients: a unified approach. Theoretical Population Biology, 21: 24-43.
}
