% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.similarity}
\alias{kernel.similarity}
\title{Pairwise similarity among kernel density hypervolumes.}
\usage{
kernel.similarity(comm)
}
\arguments{
\item{comm}{A 'HypervolumeList' object, preferably built using function kernel.build.}
}
\value{
Five pairwise distance matrices, one per each of the distance and similarity indices (in order: distance between centroids, minimum distance, Jaccard overlap, Soerensen-Dice overlap, and Intersection among hypervolumes).
}
\description{
Calculate pairwise distance metrics (centroid and minimum distance) and similarity indices (Intersection, Jaccard, Soerensen-Dice) among n-dimensional hypervolumes.
}
\details{
Computes a pairwise comparison between kernel density hypervolumes of multiple species or communities, based on the distance and similarity metrics implemented in hypervolume R package (Blonder et al., 2014, 2018).
See Mammola (2019) for a description of the different indices, and a comparison between their performance. Note that computation time largely depends on the number of 'Hypervolume' objects in the list, and scales almost exponentially with the number of hypervolume axes.
}
\examples{
\dontrun{
comm <- rbind(c(1,1,1,1,1), c(1,1,1,1,1), c(0,0,1,1,1),c(0,0,1,1,1))
colnames(comm) = c("SpA","SpB","SpC","SpD", "SpE")
rownames(comm) = c("Site 1","Site 2","Site 3","Site 4")

trait <- cbind(c(2.2,4.4,6.1,8.3,3),c(0.5,1,0.5,0.4,4),c(0.7,1.2,0.5,0.4,5),c(0.7,2.2,0.5,0.3,6))
colnames(trait) = c("Trait 1","Trait 2","Trait 3","Trait 4")
rownames(trait) = colnames(comm)

hvlist = kernel.build(comm, trait)
kernel.similarity(hvlist)
hvlist = kernel.build(comm, trait, axes = 0.9)
kernel.similarity(hvlist)
}
}
\references{
Blonder, B., Lamanna, C., Violle, C. & Enquist, B.J. (2014) The n-dimensional hypervolume. Global Ecology and Biogeography, 23: 595-609.

Blonder, B., Morrow, C.B., Maitner, B., Harris, D.J., Lamanna, C., Violle, C., ... & Kerkhoff, A.J. (2018) New approaches for delineating n-dimensional hypervolumes. Methods in Ecology and Evolution, 9: 305-319.

Mammola, S. (2019) Assessing similarity of n-dimensional hypervolumes: Which metric to use?. Journal of Biogeography, 46: 2012-2023.
}
