% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-data-documentation.R
\docType{data}
\name{lizard}
\alias{lizard}
\title{Lizard Dataset}
\format{A matrix with 68 rows (observed units) and 30 columns (capture occasions)}
\source{
Wanger T.C. et al. (2009)
}
\usage{
data(lizard)
}
\description{
Giant day gecko's capture history data observed in Masoala rainforest exhibit, Zurich Zoo. This datatset was first ussed in Wanger T.C. et al. (2009).
}
\details{
The giant day gecko (Phelsuma madagascariensis grandis) is a tropical reptile naturally occurring in the northern part of Madagascar. Data represent an extensive capture-recapture experiment at the  Masoala rainforest exhibit, Zurich Zoo. The researchers used the individual color patterns of this gecko species for photo recognition. Due to the high number of sampling sessions, this study is based on an unusually good dataset.  Moreover, it is a captive population and, therefore, we can be sure that the closed population assumption is valid. However, the dataset is comparable to natural conditions because of the dimensions of the Masoala rainforest exhibit; it is currently the second largest tropical exhibit in the world. Additional variation in the dataset results from time-dependent variation in recapture rates (obvious dependence of gecko activity on daily weather) and the photographic capture method (it is harder to spot and photograph juvenile compared to adult geckos).
}
\examples{

data(lizard)
str(lizard)

}
\references{
Wanger T.C. et al. (2009) How to monitor elusive lizards: comparison of capture-recapture methods on giant day geckos (Gekkonidae, Phelsuma madagascariensis grandis) in the Masoala rainforest exhibit, Zurich Zoo. Ecological Research 24(2):345--353.
}
\keyword{Datasets}
