% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_MAPdag.R
\name{get_MAPdag}
\alias{get_MAPdag}
\title{Compute the maximum a posteriori DAG model from the MCMC output}
\usage{
get_MAPdag(learnDAG_output)
}
\arguments{
\item{learnDAG_output}{object of class \code{bcdag}}
}
\value{
The \eqn{(q,q)} adjacency matrix of the maximum a posteriori DAG model
}
\description{
This function computes the maximum a posteriori DAG model estimate (MAP) from the MCMC output of \code{learn_DAG}
}
\details{
Output of \code{learn_dag} function consists of \eqn{S} draws from the joint posterior of DAGs and DAG-parameters in a zero-mean Gaussian DAG-model;
see the documentation of \code{learn_DAG} for more details.

The Maximum A Posteriori (MAP) model estimate is defined as the DAG visited by the MCMC with the highest associated posterior probability.
Each DAG posterior probability is estimated as the frequency of visits of the DAG in the MCMC chain.
The MAP estimate is represented through its \eqn{(q,q)} adjacency matrix, with \eqn{(u,v)}-element equal to one whenever the MAP contains \eqn{u -> v},
zero otherwise.
}
\examples{
# Randomly generate a DAG and the DAG-parameters
q = 8
w = 0.2
set.seed(123)
DAG = rDAG(q = q, w = w)
outDL = rDAGWishart(n = 1, DAG = DAG, a = q, U = diag(1, q))
L = outDL$L; D = outDL$D
Sigma = solve(t(L))\%*\%D\%*\%solve(L)
# Generate observations from a Gaussian DAG-model
n = 200
X = mvtnorm::rmvnorm(n = n, sigma = Sigma)
# Run the MCMC (Set S = 5000 and burn = 1000 for better results)
out_mcmc = learn_DAG(S = 500, burn = 100, a = q, U = diag(1,q)/n, data = X, w = 0.1,
                     fast = TRUE, save.memory = FALSE)
# Produce the MAP DAG estimate
get_MAPdag(out_mcmc)

}
\references{
F. Castelletti and A. Mascaro (2021). Structural learning and estimation of joint causal effects among network-dependent variables. \emph{Statistical Methods and Applications}, Advance publication.

G. Garcia-Donato and M.A. Martinez-Beneito (2013). On sampling strategies in Bayesian variable selection problems with large model spaces. \emph{Journal of the American Statistical Association} 108 340-352.
}
\author{
Federico Castelletti and Alessandro Mascaro
}
