% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_estimate.default.R
\name{ggm_compare_estimate.default}
\alias{ggm_compare_estimate.default}
\title{Compare Edges (Partial Correlations) Between GGMs with the Posterior Distribution}
\usage{
\method{ggm_compare_estimate}{default}(..., iter = 5000)
}
\arguments{
\item{...}{data matrices. Requires at least two.}

\item{iter}{number of posterior samples}
}
\value{
A list of class \code{ggm_compare_estimate} containing:
 \itemize{
 \item \code{pcor_diffs} partial correlation differences (posterior distribution)
 \item \code{p} number of variable
 \item \code{info} list containing information about each group (e.g., sample size, etc.)
 \item \code{iter} number of posterior samples
 \item \code{call} \code{match.call}
 }
}
\description{
Compare edges (partial correlations) that are estimated from groups to, say, detect differences or equivalences.
}
\note{
The work flow for most functions in \strong{BGGM} is to first fit the model
and then select the graph  (in this case the differences) with  \code{\link{select}}.
}
\examples{
# data
Y1 <- BGGM::bfi[1:500,1:5]
Y2 <- BGGM::bfi[501:1000, 1:5]

# fit model
fit <- ggm_compare_estimate(Y1, Y2)

# posterior summary of differences
summary(fit)

# select (threshold) with credible intervals
sel <- select(fit)

# summary
summary(sel)

# selected differences
sel$mat_pcor

# adjacency matrix
sel$mat_adj
}
\seealso{
\code{\link{select.ggm_compare_estimate}}
}
