\name{GaPloth}

\alias{GaPloth}

\title{Plots for the Hazard and Survival Function Estimates}

\description{
Plots the resulting hazard function along with the survival function estimate defined by the Markov gamma process (Nieto-Barajas and Walker, 2002).
}

\usage{
GaPloth(M, fun = "both", confint = TRUE, h.NA = TRUE, KM = TRUE, 
confidence = 0.95, summary = FALSE, legend = TRUE)
}

\arguments{
  \item{M}{List. Contains the information given for lambda and u (generated by \code{GaMRres}).}
  \item{fun}{"h"=plots hazard function; "S"= plots survival function and "both"=plots both the hazard and survival functions.}
  \item{confint}{Logical. If \code{TRUE}, plots confidence bands for the selected functions including Nelson-Aalen and/or Kaplan-Meier estimate.}
  \item{h.NA}{Logical. If \code{TRUE}, Nelson-Aalen estimate is plotted over the hazard function.}
  \item{KM}{Logical. If \code{TRUE}, Kaplan-Meier estimate is plotted over the survival function.}
  \item{confidence}{Numeric. Confidence band width.}
  \item{summary}{Logical. If \code{TRUE}, a summary for hazard and survival functions is returned as a list.}
  \item{legend}{Logical. If \code{FALSE}, legend is not shown.}
}

\details{
This function return plots for the resulting hazard rate as it is computed by \code{\link{GaMRes}} and the Nelson-Aalen estimate along with their confidence intervals for the data set given. Additionally, it plots the survival function and the Kaplan-Meier estimate with their corresponding confidence intervals.
}

\value{
  \item{SUM.h}{Numeric matrix. Summary for the mean, median, and a \code{confint / 100} confidence interval for each segment of the hazard function.}
  \item{SUM.S}{Numeric matrix. Summary for the mean, median, and a \code{confint / 100} confidence interval for each segment of the survival function.}
}

\references{
Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and gamma processes for modelling hazard rates. Scandinavian Journal of Statistics 29, 413-424.
}

\author{
Garcia-Bueno, J.A. & Nieto-Barajas, L.E.
}

\section{Warning}{The argument \code{fun} is case-sensitive and requires quotations as its class is character.}

\seealso{
\link{GaMRes}, \link{GaPlotDiag}
}

\examples{
## Examples are be computing intensive. Be patient.
## require(MASS)
## data1 <- gehan[gehan[,4] == "6-MP", 2:3]
## times <- data1[, 1]; delta <- data1[, 2]
## EX <- GaMRes(times, delta)
## GaPloth(EX, confint = FALSE)
## GaPloth(EX, fun = "both", confint = TRUE)
}