% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGaPlotDiag.R
\name{CGaPlotDiag}
\alias{CGaPlotDiag}
\title{Diagnostics plots for lambda, U, C, Epsilon and Theta}
\usage{
CGaPlotDiag(M, variable = "Lambda", pos = 1)
}
\arguments{
\item{M}{Tibble. Contains the output by \code{CGaMRes}}

\item{variable}{Either "Lambda", "U", "C", "Epsilon" or "Theta". Variable
for which diagnostics plot will be shown.}

\item{pos}{Positive integer. Position of the selected \code{variable} to be
plotted.}
}
\description{
Diagnostics plots for hazard rate (Lambda), latent variable (U), dependence
variable (C), parameter of the hierarchical model (Epsilon) and regression
coefficients (Theta).
}
\details{
This function returns a diagnostics plot for the chain of the selected
variable. The diagnostics includes trace, ergodic mean, autocorrelation
function and histogram.
}
\examples{


 
## Simulations may be time intensive. Be patient.

## Example 1
#  data(leukemiaFZ)
#  leukemia1 <- leukemiaFZ
#  leukemia1$wbc <- log(leukemiaFZ$wbc)
#  CGEX1 <- CGaMRes(data = leukemia1, K = 10, iterations = 1000, thinning = 1)
#  CGaPlotDiag(CGEX1,variable="Theta",pos=1)



}
\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma
processes and time dependent covariates in survival analysis. \emph{Bulletin
of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and gamma
processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{CGaMRes}
}
