% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_traitbyfamily}
\alias{BIEN_trait_traitbyfamily}
\title{Download trait data for given families and traits.}
\usage{
BIEN_trait_traitbyfamily(
  family,
  trait,
  all.taxonomy = FALSE,
  political.boundaries = FALSE,
  source.citation = FALSE,
  ...
)
}
\arguments{
\item{family}{A single family or a vector of families.}

\item{trait}{A single trait or a vector of traits.}

\item{all.taxonomy}{Should full taxonomic information and TNRS output be returned?  Default is FALSE.}

\item{political.boundaries}{Should political boundary information (country, state, etc.) be returned?  Default is FALSE.}

\item{source.citation}{Should readable source information be downloaded for each record?  Note that \code{\link{BIEN_metadata_citation}} may be more useful.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe of all data matching the specified trait(s) and family/families.
}
\description{
BIEN_trait_traitbyfamily extracts entries that contain the specified families and trait(s).
}
\note{
Trait spelling needs to be exact and case-sensitive, see \code{\link{BIEN_trait_list}} for a list of traits.
}
\examples{
\dontrun{
BIEN_trait_traitbyfamily(trait = "whole plant height", family = "Poaceae")
trait_vector <- c("whole plant height", "leaf fresh mass")
family_vector < -c("Orchidaceae","Poaceae")
BIEN_trait_traitbyfamily(trait = trait_vector, family = family_vector)}
}
\seealso{
Other trait functions: 
\code{\link{BIEN_trait_country}()},
\code{\link{BIEN_trait_family}()},
\code{\link{BIEN_trait_list}()},
\code{\link{BIEN_trait_mean}()},
\code{\link{BIEN_trait_species}()},
\code{\link{BIEN_trait_traitbygenus}()},
\code{\link{BIEN_trait_traitbyspecies}()},
\code{\link{BIEN_trait_traits_per_species}()},
\code{\link{BIEN_trait_trait}()}
}
\concept{trait functions}
