% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-Model.R
\name{set_coef}
\alias{set_coef}
\title{Set Coefficients for BKT Model}
\usage{
set_coef(object, values)
}
\arguments{
\item{object}{An object of the BKT model. This is the model for which the parameters will be set or initialized.}

\item{values}{A list containing the skill names and their corresponding BKT parameters.
Each skill should have its own list of parameters.
The parameters can include 'prior', 'learns', 'forgets', 'guesses', and 'slips'.
Example structure: \code{list("skill_name" = list("learns" = ..., "guesses" = ...))}.}
}
\value{
The updated BKT model object with the newly set coefficients.
}
\description{
This function sets or initializes the parameters of a Bayesian Knowledge Tracing (BKT) model.
The user can manually specify the values for different parameters associated with specific skills.
}
\details{
This function allows users to manually specify or update the parameters of a BKT model for different skills.
The values should be provided as a named list, with each skill having its own sublist of BKT parameters.
The function performs checks to ensure that the provided parameters are valid in terms of type, length, and existence.
}
\examples{
\donttest{
# Initialize a BKT model
model <- bkt(seed = 42)

# Set custom parameters for a specific skill
model <- set_coef(model, list(
  "Plot non-terminating improper fraction" = list("prior" = 0.5, "learns" = 0.2)
))

# Fit the model with fixed parameters
result <- fit(model,
  forgets = TRUE,
  data_path = "ct.csv",
  skills = "Plot non-terminating improper fraction",
  fixed = list("Plot non-terminating improper fraction" = list("prior" = TRUE))
)
}
}
