% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bme_predict.R
\name{bme_predict}
\alias{bme_predict}
\title{Bayesian Maximum Entropy (BME) Spatial Interpolation}
\usage{
bme_predict(x, ch, cs, zh, a, b,
            model, nugget, sill, range, nsmax = 5,
            nhmax = 5, n = 50, zk_range = extended_range(zh, a, b),
            type)
}
\arguments{
\item{x}{A two-column matrix of spatial coordinates for the estimation
locations.}

\item{ch}{A two-column matrix of spatial coordinates for hard data locations.}

\item{cs}{A two-column matrix of spatial coordinates for soft (interval) data
locations.}

\item{zh}{A numeric vector of observed values at the hard data locations.}

\item{a}{A numeric vector of lower bounds for the soft interval data.}

\item{b}{A numeric vector of upper bounds for the soft interval data.}

\item{model}{A string specifying the variogram or covariance model to use
(e.g., \code{"exp"}, \code{"sph"}, etc.).}

\item{nugget}{A non-negative numeric value for the nugget effect in the
variogram model.}

\item{sill}{A numeric value representing the sill (total variance) in the
variogram model.}

\item{range}{A positive numeric value for the range (or effective range)
parameter of the variogram model.}

\item{nsmax}{An integer specifying the maximum number of nearby soft data
points to include for estimation (default is 5).}

\item{nhmax}{An integer specifying the maximum number of nearby hard data
points to include for estimation (default is 5).}

\item{n}{An integer indicating the number of points at which to evaluate the
posterior density over \code{zk_range} (default is 50).}

\item{zk_range}{A numeric vector specifying the range over which to evaluate
the unobserved value at the estimation location (\code{zk}). Although
\code{zk} is unknown,  it is assumed to lie within a range similar to
the observed data (\code{zh}, \code{a}, and \code{b}). It is advisable
to explore the posterior distribution at a few locations using
\code{prob_zk()} before finalizing this range. The default is
\code{extended_range(zh, a, b)}.}

\item{type}{A string indicating the type of BME prediction to compute: either
\code{"mean"} for the posterior mean or \code{"mode"} for the
posterior mode.}
}
\value{
A data frame with either 3 or 4 columns, depending on the prediction
type. The first two columns contain the geographic coordinates. If
\code{type = "mean"}, the third and fourth columns represent the
posterior mean and its associated variance, respectively. If
\code{type = "mode"}, only a third column is returned for the
posterior mode.
}
\description{
\code{bme_predict} performs BME spatial interpolation at user-specified
estimation locations. It uses both hard data (precise measurements) and soft
data (interval or uncertain measurements), along with a specified variogram
model, to compute either the posterior mean or mode and associated variance
for each location. This function enables spatial prediction in settings where
uncertainty in data must be explicitly accounted for, improving estimation
accuracy when soft data is available.
}
\examples{
data("utsnowload")
x <- utsnowload[1, c("latitude", "longitude")]
ch <- utsnowload[2:67, c("latitude", "longitude")]
cs <- utsnowload[68:232, c("latitude", "longitude")]
zh <- utsnowload[2:67, c("hard")]
a <- utsnowload[68:232, c("lower")]
b <- utsnowload[68:232, c("upper")]
bme_predict(x, ch, cs, zh, a, b,
  model = "exp", nugget = 0.0953,
  sill = 0.3639, range = 1.0787, type = "mean"
)

}
