% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfit.R
\name{plotfit_noncensored}
\alias{plotfit_noncensored}
\title{Plot the density estimate and the 95\% credible interval for noncensored
data}
\usage{
plotfit_noncensored(fit)
}
\arguments{
\item{fit}{A fitted object of class NRMI1 or NRMI2}
}
\value{
A graph with the density estimate, the 95\% credible interval and a
histogram of the data
}
\description{
The density estimate is the mean posterior density computed on the data
points.
}
\examples{

data(acidity)
out <- MixNRMI1(acidity, Nit = 50)
plot(out)
}
