% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cDDP}
\alias{cDDP}
\title{C++ function to estimate DDP models with 1 grouping variables}
\arguments{
\item{data}{a vector of observations.}

\item{group}{group allocation of the data.}

\item{ngr}{number of groups.}

\item{grid}{vector to evaluate the density.}

\item{niter}{number of iterations.}

\item{nburn}{number of burn-in iterations.}

\item{m0}{expectation of location component.}

\item{k0}{tuning parameter of variance of location component.}

\item{a0}{parameter of scale component.}

\item{b0}{parameter of scale component.}

\item{mass}{mass of Dirichlet process.}

\item{wei}{prior weight of the specific processes.}

\item{napprox}{number of approximating values.}

\item{n_approx_unif}{number of approximating values of the importance step for the weights updating.}

\item{nupd}{number of iterations to show current updating.}

\item{out_dens}{if TRUE, return also the estimated density (default TRUE).}

\item{print_message}{print the status.}

\item{light_dens}{if TRUE return only the posterior mean of the density}
}
\description{
C++ function to estimate DDP models with 1 grouping variables
}
\examples{
{
  data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
  group_toy <- c(rep(1,100), rep(2,100))
  grid <- seq(-7, 7, length.out = 50)
  est_model <- cDDP(data_toy, group_toy, 2, grid, 20, 10,
    0, 1, 2, 1, 1, 0.5, 10, 1000, 100, 1, 1, 1)
  \dontshow{
    data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
    group_toy <- c(rep(1,100), rep(2,100))
    grid <- seq(-7, 7, length.out = 50)
    est_model <- cDDP(data_toy, group_toy, 2, grid, 20, 10,
      0, 1, 2, 1, 1, 0.5, 10, 1000, 100, 1, 1, 1)
  }
  \donttest{
    data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
    group_toy <- c(rep(1,100), rep(2,100))
    grid <- seq(-7, 7, length.out = 50)
    est_model <- cDDP(data_toy, group_toy, 2, grid, 1000, 100,
      0, 1, 2, 1, 1, 0.5, 10, 1000, 100, 1, 1, 1)
  }
}

}
