% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.oc.R
\name{get.oc}
\alias{get.oc}
\title{Generate operating characteristics for single agent trials}
\usage{
get.oc(target, p.true, ncohort, cohortsize, n.earlystop=100,
              startdose=1, p.saf=0.6*target, p.tox=1.4*target, cutoff.eli=0.95,
              extrasafe=FALSE, offset=0.05, ntrial=1000)
}
\arguments{
\item{target}{the target toxicity rate}

\item{p.true}{a vector containing the true toxicity probabilities of the
investigational dose levels.}

\item{ncohort}{the total number of cohorts}

\item{cohortsize}{the cohort size}

\item{n.earlystop}{the early stopping parameter. If the number of patients
treated at the current dose reaches \code{n.earlystop},
stop the trial and select the MTD based on the observed data.
The default value \code{n.earlystop=100} essentially turns
off this type of early stopping.}

\item{startdose}{the starting dose level for the trial}

\item{p.saf}{the highest toxicity probability that is deemed subtherapeutic
(i.e. below the MTD) such that dose escalation should be undertaken.
The default value is \code{p.saf=0.6*target}.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such
that deescalation is required. The default value is \code{p.tox=1.4*target}).}

\item{cutoff.eli}{the cutoff to eliminate an overly toxic dose for safety.
We recommend the default value of (\code{cutoff.eli=0.95}) for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more stringent stopping rule}

\item{offset}{a small positive number (between 0 and 0.5) to control how strict the
stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a more
strict stopping rule. The default value \code{offset=0.05} generally works well.}

\item{ntrial}{the total number of trials to be simulated.}
}
\value{
\code{get.oc()} returns the operating characteristics of the BOIN design as a data frame,
        including: (1) selection percentage at each dose level (\code{selpercent}),
        (2) the number of patients treated at each dose level (\code{nptsdose}),
        (3) the number of toxicities observed at each dose level (\code{ntoxdose}),
        (4) the average number of toxicities (\code{totaltox}),
        (5) the average number of patients (\code{totaln}),
        and (6) the percentage of early stopping without selecting the MTD (\code{pctearlystop}).
}
\description{
Obtain the operating characteristics of the BOIN design for single agent trials by simulating trials.
}
\details{
The operating characteristics of the BOIN design are generated by simulating trials
         under the prespecified true toxicity probabilities of the investigational doses.
         The BOIN design has two built-in stopping rules: (1) stop the trial if the lowest
         dose is eliminated due to toxicity, and no dose should be selected as the MTD; and
         (2) stop the trial and select the MTD if the number of patients treated at the current
         dose reaches \code{n.earlystop}. The first stopping rule is a safety rule to protect patients
         from the case in which all doses are overly toxic. The rationale for the second stopping
         rule is that when there is a large number (i.e., \code{n.earlystop}) of patients
         assigned to a dose, it means that the dose-finding algorithm has approximately converged.
         Thus, we can stop the trial early and select the MTD to save sample size and reduce the
         trial duration. For some applications, investigators may prefer a more strict safety
         stopping rule than rule (1) for extra safety when the lowest dose is overly toxic.
         This can be achieved by setting \code{extrasafe=TRUE}, which imposes the following more
         strict safety stopping rule: stop the trial if (i) the number of patients treated at the
         lowest dose \code{>=3}, and (ii) Pr(toxicity rate of the lowest dose > \code{target} | data)
         > \code{cutoff.eli-offset}. As a tradeoff, the strong stopping rule will decrease the MTD
         selection percentage when the lowest dose actually is the MTD.
}
\note{
We should avoid setting the values of \code{p.saf} and \code{p.tox} very close to the \code{target}.
      This is because the small sample sizes of typical phase I trials prevent us from
      differentiating the target toxicity rate from the rates close to it. In addition,
      in most clinical applications, the target toxicity rate is often a rough guess,
      and finding a dose level with a toxicity rate reasonably close to the target rate
      will still be of interest to the investigator. The default values provided by
      \code{get.oc()} are generally reasonable for most clinical applications.
}
\examples{
get.oc(target=0.3, p.true=c(0.05, 0.15, 0.3, 0.45, 0.6), ncohort=1000, cohortsize=3, ntrial=1000)
}
\author{
Suyu Liu and Ying Yuan
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I
            Clinical Trials, Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.4_tutorial.pdf}

         Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

