% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_single_exp_nocovar.R
\name{fit_single_exp_nocovar}
\alias{fit_single_exp_nocovar}
\title{Fit single model to data from a two-arm trial with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event}
\usage{
fit_single_exp_nocovar(data, params, summarize_fit = TRUE)
}
\arguments{
\item{data}{Data frame of a structure as generated by \code{sim_dat_one_trial_exp_nocovar()}.}

\item{params}{List, containing model parameters:
\itemize{
\item \code{tg} Positive integer value, number of intervals to calculate restricted mean survival time using the trapezoidal rule.
\item \code{prior_piT} Numeric vector of length 2, containing parameters (alpha, beta) of the beta prior on pi, indicating the probability of belonging to the stratum of subjects developing the intercurrent event if given treatment.
\item \code{prior_0N} Numeric vector of length 2, containing parameters (alpha, beta) of the gamma prior on lambda_0N.
\item \code{prior_1N} Numeric vector of length 2, containing parameters (alpha, beta) of the gamma prior on lambda_1N.
\item \code{prior_0T} Numeric vector of length 2, containing parameters (alpha, beta) of the gamma prior on lambda_0T.
\item \code{prior_1T} Numeric vector of length 2, containing parameters (alpha, beta) of the gamma prior on lambda_1T.
\item \code{t_grid} Numeric vector of length \code{tg}, containing time points defining the time grid (in months) to calculate restricted mean survival time using the trapezoidal rule.
\item \code{chains} Positive integer value, specifying the number of Markov chains.
\item \code{n_iter} Positive integer value, specifying the number of iterations for each chain (including warmup).
\item \code{warmup} Positive integer value, specifying the number of warmup (aka burnin) iterations per chain.
\item \code{cores} Positive integer value, specifying the number of cores to use when executing the chains in parallel.
\item \code{open_progress} Logical value, indicating whether the progress of the chains will be redirected to a file that is automatically opened for inspection.
\item \code{show_messages} Logical value, indicating whether to print the summary of informational messages.
}}

\item{summarize_fit}{Logical, if \code{TRUE} (default), the output is restricted to a summary of results on key parameters over all chains, if \code{FALSE}, the complete \code{stanfit} object is returned.}
}
\value{
\code{tibble()} containing a summary of results on key parameters, or a \code{stanfit} object, depending on \code{summarize_fit}.
}
\description{
Fit single model to data from a two-arm trial with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event
}
\details{
The data supplied as \code{params} are used either as priors (\code{prior_delta}, \code{prior_0N}, \code{prior_1N}, \code{prior_1T}), to inform the model setup (\code{tg}, \code{p}, \code{t_grid}), or as parameters to \code{rstan::sampling()} which is invoked internally (\code{chains}, \code{n_iter}, \code{warmup}, \code{cores}, \code{open_progress}, \code{show_messages}).
}
\examples{
d_params_nocovar <- list(
  n = 500L,
  nt = 250L,
  prob_ice = 0.5,
  fu_max = 336L,
  T0T_rate = 0.2,
  T0N_rate = 0.2,
  T1T_rate = 0.15,
  T1N_rate = 0.1
)
dat_single_trial <- sim_dat_one_trial_exp_nocovar(
  n = d_params_nocovar[["n"]], 
  nt = d_params_nocovar[["nt"]],
  prob_ice = d_params_nocovar[["prob_ice"]],
  fu_max = d_params_nocovar[["fu_max"]],  
  T0T_rate = d_params_nocovar[["T0T_rate"]],
  T0N_rate = d_params_nocovar[["T0N_rate"]],
  T1T_rate = d_params_nocovar[["T1T_rate"]],
  T1N_rate = d_params_nocovar[["T1N_rate"]] 
)
m_params_nocovar <- list(
  tg = 48L,
  prior_piT = c(0.5, 0.5),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2L,
  n_iter = 3000L,
  warmup = 1500L,
  cores = 2L,
  open_progress = FALSE,
  show_messages = TRUE
)
\donttest{
fit_single <- fit_single_exp_nocovar(
  data = dat_single_trial,
  params = m_params_nocovar,
  summarize_fit = TRUE
)
print(fit_single)
}
}
\seealso{
\code{\link[=fit_single_exp_covar]{fit_single_exp_covar()}} and \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}
}
