% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BRACoD.R
\name{run_bracod}
\alias{run_bracod}
\title{Run the main BRACoD algorithm}
\usage{
run_bracod(df_relab, env_var, n_sample = 1000, n_burn = 1000, njobs = 4)
}
\arguments{
\item{df_relab}{A dataframe of relative microbiome abundances. Samples are rows and bacteria are columns.}

\item{env_var}{the environmental variable you are evaluating. You need 1 measurement associated with each sample.}

\item{n_sample}{number of posterior samples.}

\item{n_burn}{number of burn-in steps before actual sampling stops.}

\item{njobs}{number of parallel MCMC chains to run.}
}
\value{
the pymc trace object which holds the samples of the posterior distribution
}
\description{
Uses pymc3 to sample the posterior of the model to determine bacteria that are
associated with your environmental variable.
}
\examples{
\dontrun{
data(obesity)
r <- simulate_microbiome_counts(obesity)
sim_counts <- r[[1]]
sim_y <- r[[2]]
contributions <- r[[3]]
sim_relab <- scale_counts(sim_counts)
trace <- run_bracod(sim_relab, sim_y, n_sample = 1000, n_burn=1000, njobs=4)
}
}
