% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Gallup}
\alias{Gallup}
\title{Results of a Gallup poll on possession of marijuana as a criminal offense
conducted in 1980}
\format{
A data frame/tibble with 1,200 observations on two variables
\describe{ 
\item{demographics}{a factor with levels \code{National}, \code{Gender: Male}
\code{Gender: Female}, \code{Education: College}, \code{Eduction: High School},
\code{Education: Grade School}, \code{Age: 18-24}, \code{Age: 25-29}, \code{Age: 30-49},
\code{Age: 50-older}, \code{Religion: Protestant}, and \code{Religion: Catholic}} 
\item{opinion}{a factor with levels \code{Criminal}, \code{Not Criminal}, and \code{No Opinion}}
}
}
\source{
George H. Gallup \emph{The Gallup Opinion Index Report No. 179} (Princeton, NJ:
The Gallup Poll, July 1980), p. 15.
}
\usage{
Gallup
}
\description{
Data for Exercise 2.76
}
\examples{

T1 <- xtabs(~demographics + opinion, data = Gallup)
T1
t(T1[c(2, 3), ])
barplot(t(T1[c(2, 3), ]))
barplot(t(T1[c(2, 3), ]), beside = TRUE)

\dontrun{
library(dplyr)
library(ggplot2)
dplyr::filter(Gallup, demographics == "Gender: Male" | demographics == "Gender: Female") \%>\%
ggplot2::ggplot(aes(x = demographics, fill = opinion)) + 
           geom_bar() + 
           theme_bw() + 
           labs(y = "Fraction")
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
