% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_calculation.R
\name{calc_mscore}
\alias{calc_mscore}
\title{Calculating Boolean model score wrt to a dataset}
\usage{
calc_mscore(bmodel, istate, fcdata, overlap_gene, max_varperrule,
  model_encoding, detail = F)
}
\arguments{
\item{bmodel}{S4 BoolModel object. Model to be evaluated.}

\item{istate}{data frame. Must have only 1 row, which represents 1 initial state.}

\item{fcdata}{matrix. Represents the expression data df.}

\item{overlap_gene}{character vector. Specify which genes are present in both model and data inputs.}

\item{max_varperrule}{integer. Maximum number of terms per rule (combining both act and inh rule). Note that this number must not be smaller than number of variables. Default to 6.}

\item{model_encoding}{numeric. Only required if the bmodel is encoded.}

\item{detail}{logical. Whether to give more details in score calculation. Default to FALSE.}
}
\description{
This function calculates a score for a Boolean model wrt to a dataset.
}

