% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bgnbd.PlotRecVsConditionalExpectedFrequency}
\alias{bgnbd.PlotRecVsConditionalExpectedFrequency}
\title{BG/NBD Plot Actual vs. Conditional Expected Frequency by Recency}
\usage{
bgnbd.PlotRecVsConditionalExpectedFrequency(params, cal.cbs, T.star, x.star,
  xlab = "Calibration period recency", ylab = "Holdout period transactions",
  xticklab = NULL,
  title = "Actual vs. Conditional Expected Transactions by Recency")
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that order. r and alpha are unobserved parameters for the NBD transaction process. a and b are unobserved parameters for the Beta geometric dropout process.}

\item{cal.cbs}{calibration period CBS (customer by sufficient statistic). It must contain columns for frequency ("x"), recency ("t.x"), and total time observed ("T.cal"). Note that recency must be the time between the start of the calibration period and the customer's last transaction, not the time between the customer's last transaction and the end of the calibration period.}

\item{T.star}{length of then holdout period.}

\item{x.star}{vector of transactions made by each customer in the holdout period.}

\item{xlab}{descriptive label for the x axis.}

\item{ylab}{descriptive label for the y axis.}

\item{xticklab}{vector containing a label for each tick mark on the x axis.}

\item{title}{title placed on the top-center of the plot.}
}
\value{
Matrix comparing actual and conditional expected
transactions in the holdout period.
}
\description{
Plots the actual and conditional expected number of transactions
made by customers in the holdout period, binned according to
calibration period recencies. Also returns a matrix with this
comparison and the number of customers in each bin.
}
\details{
This function does bin customers exactly according to recency; it
bins customers according to integer units of the time period of
cal.cbs. Therefore, if you are using weeks in your data, customers
will be binned as follows: customers with recencies between the
start of the calibration period (inclusive) and the end of week
one (exclusive); customers with recencies between the end of week
one (inclusive) and the end of week two (exlusive); etc.

The matrix and plot will contain the actual number of transactions
made by each bin in the holdout period, as well as the expected
number of transactions made by that bin in the holdout period,
conditional on that bin's behavior during the calibration period.
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# number of transactions by each customer in the 39 weeks following
# the calibration period
x.star <- cal.cbs[,"x.star"]

# parameters estimated using bgnbd.EstimateParameters
est.params <- c(0.243, 4.414, 0.793, 2.426)

# plot conditional expected holdout period transactions, binned according to
# calibration period recencies
bgnbd.PlotRecVsConditionalExpectedFrequency(est.params, cal.cbs, T.star=39, x.star)
}

