% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pnbd.PAlive}
\alias{pnbd.PAlive}
\title{Pareto/NBD P(Alive)}
\usage{
pnbd.PAlive(params, x, t.x, T.cal)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in that order. r and alpha are unobserved parameters for the NBD transaction process. s and beta are unobserved parameters for the Pareto (exponential gamma) dropout process.}

\item{x}{number of repeat transactions in the calibration
period, or a vector of transaction frequencies.}

\item{t.x}{time of most recent repeat transaction, or a
vector of recencies.}

\item{T.cal}{length of calibration period, or a vector of
calibration period lengths.}
}
\value{
Probability that the customer is still alive at the end of
the calibration period. If \code{x}, \code{t.x}, and/or
\code{T.cal} has a length greater than one, then this will be a
vector of probabilities (containing one element matching each
element of the longest input vector).
}
\description{
Uses Pareto/NBD model parameters and a customer's past
transaction behavior to return the probability that they are still
alive at the end of the calibration period.
}
\details{
P(Alive | X=x, t.x, T.cal, r, alpha, s, beta)

\code{x}, \code{t.x}, and \code{T.cal} may be vectors. The
standard rules for vector operations apply - if they are not of
the same length, shorter vectors will be recycled (start over at
the first element) until they are as long as the longest
vector. It is advisable to keep vectors to the same length and to
use single values for parameters that are to be the same for all
calculations. If one of these parameters has a length greater than
one, the output will be a vector of probabilities.
}
\examples{
params <- c(0.55, 10.56, 0.61, 11.64)

pnbd.PAlive(params, x=0, t.x=0, T.cal=39)
# 0.2924031; P(Alive) of a customer who made no repeat transactions.

pnbd.PAlive(params, x=23, t.x=39, T.cal=39)
# 1; P(Alive) of a customer who has the same recency and total
# time observed.

pnbd.PAlive(params, x=5:20, t.x=30, T.cal=39)
# Note the "increasing frequency paradox".

# To visualize the distribution of P(Alive) across customers:

data(cdnowSummary)
cbs <- cdnowSummary$cbs
params <- pnbd.EstimateParameters(cbs)
p.alives <- pnbd.PAlive(params, cbs[,"x"], cbs[,"t.x"], cbs[,"T.cal"])
plot(density(p.alives))
}
\references{
Fader, Peter S., and Bruce G.S. Hardie. \dQuote{A Note on Deriving the Pareto/NBD Model and Related Expressions.} November. 2005. Web. \url{http://www.brucehardie.com/notes/008/}
}

