% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/85_plot_fcast.R
\name{plot.bvar_fcast}
\alias{plot.bvar_fcast}
\alias{bv_plot_fcast}
\title{Forecast plot}
\usage{
\method{plot}{bvar_fcast}(x, conf_bands = 0.16, variables = NULL,
  vars = NULL, orientation = c("vertical", "horizontal"), mar = c(2,
  2, 2, 0.5), ...)

bv_plot_fcast(x, conf_bands = 0.16, variables = NULL, vars = NULL,
  orientation = c("vertical", "horizontal"), mar = c(2, 2, 2, 0.5),
  ...)
}
\arguments{
\item{x}{A \code{bvar} / \code{bvar_fcast} object, obtained from
\code{\link{bvar}}.}

\item{conf_bands}{Numeric vector of desired confidence bands. E.g. for bands
at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.}

\item{variables}{Optional character vector. Names of all variables in the
object. Taken from \code{x$variables} if available.}

\item{vars}{Optional numeric or character vector. Used to subset the plot to
certain variables by position or name (\code{variables} must be available).
Defaults to \code{NULL}, i.e. all variables.}

\item{orientation}{String indicating the orientation of the plots. Defaults
to \code{"v"} (i.e. vertical); may be set to \code{"h"} (i.e. horizontal).}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\description{
Plotting method for forecasts obtained from \code{\link{bvar}}. Forecasts
of all or a subset of the available variables can be plotted.
}
\examples{
\donttest{
data <- matrix(rnorm(400), ncol = 4)
x <- bvar(data, lags = 2)

# Plot forecasts for all available variables
bv_plot_fcast(x)

# Subset to variables in positions 1, 2 and 4 via position and name
bv_plot_fcast(x, vars = c(1, 2, 4))

# Use the method to plot, adjust confidence bands and orientation
plot(x$fcast, conf_bands = c(0.01, 0.05), orientation = "h")
}
}
