% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{move}
\alias{move}
\alias{move,Organism-method}
\title{Function for random movement of organisms}
\usage{
move(object, pos, n, m, j)

\S4method{move}{Organism}(object, pos, n, m, j)
}
\arguments{
\item{object}{An object of class Organism.}

\item{pos}{A dataframe with all occupied x and y positions}

\item{n}{A number giving the horizontal size of the environment.}

\item{m}{A number giving the vertical size of the environment.}

\item{j}{The number of the iteration of interest.}
}
\description{
The generic function \code{move} implements a random movement in the Moore neighbourhood of an individual.
}
\details{
Organisms move in a random position the Moore neighbourhood, which is not occupied by other individuals. If there is no free space the individuals stays in the same position.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
move(bac,n=20,m=20,j=1,pos=arena@orgdat[,c('x','y')])
}
\seealso{
\code{\link{Organism-class}}, \code{\link{emptyHood}}
}

