% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coveff.R
\name{plot_coveff}
\alias{plot_coveff}
\alias{plot_coveff.ermod}
\alias{plot_coveff.coveffsim}
\title{Visualize the covariate effects for ER model}
\usage{
plot_coveff(x, ...)

\method{plot_coveff}{ermod}(
  x,
  data = NULL,
  spec_coveff = NULL,
  qi_width = 0.9,
  qi_width_cov = 0.9,
  ...
)

\method{plot_coveff}{coveffsim}(x, ...)
}
\arguments{
\item{x}{an object of class \code{ermod}, \code{coveffsim},
or their subclasses}

\item{...}{currently not used}

\item{data}{an optional data frame to derive the covariate values for
forest plots. If NULL (default), the data used to fit the model is used.}

\item{spec_coveff}{you can supply spec_coveff to \code{\link[=sim_coveff]{sim_coveff()}} or
\code{\link[=plot_coveff]{plot_coveff()}}, if you have already built it manually or with
\code{\link[=build_spec_coveff]{build_spec_coveff()}}. See \code{\link[=build_spec_coveff]{build_spec_coveff()}} for detail.}

\item{qi_width}{the width of the credible interval on the covariate effect.
This translate to the width of the error bars in the forest plot.}

\item{qi_width_cov}{the width of the quantile interval for continuous
covariates in the forest plot. Default is 0.9 (i.e. visualize effect of
covariate effect at their 5th and 95th percentile values).}
}
\value{
A ggplot object
}
\description{
Visualize the covariate effects for ER model
}
\examples{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

plot_coveff(ermod_bin)

}
