% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{init_lambda_hyperparameters}
\alias{init_lambda_hyperparameters}
\title{Initialize lambda hyperparameters}
\usage{
init_lambda_hyperparameters(group_data, s, w = 0.5)
}
\arguments{
\item{group_data}{group level data}

\item{s}{split points}

\item{w}{weight}
}
\value{
shape and rate for the estimated lambda distribution
}
\description{
Propose lambda hyperparameters for the choice of 
initial values for lambda
}
\examples{
set.seed(111)
# Load example data and set your initial values and hyper parameters
data(weibull_cc, package = "BayesFBHborrow")
data(weibull_hist, package = "BayesFBHborrow")

Y <- weibull_cc$tte
I <- weibull_cc$event
X <- weibull_cc$X_trt

# Say we want to know the group level data for the following split points
s <- quantile(Y, c(0, 0.45, 0.65, 1), names = FALSE)

group_data <- group_summary(Y, I, NULL, s)
init_lambda_hyperparameters(group_data, s)
}
