% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GibbsMH.R
\name{GibbsMH.NoBorrow}
\alias{GibbsMH.NoBorrow}
\title{GibbsMH sampler, without Bayesian Borrowing}
\usage{
\method{GibbsMH}{NoBorrow}(
  Y,
  I,
  X = NULL,
  Y_0 = NULL,
  I_0 = NULL,
  X_0 = NULL,
  tuning_parameters,
  hyperparameters = list(a_sigma = 1, b_sigma = 1, phi = 3, clam_smooth = 0.8),
  lambda_hyperparameters = list(a_lambda = 0.01, b_lambda = 0.01),
  iter = 1500L,
  warmup_iter = 10L,
  refresh = 0,
  max_grid = 2000L
)
}
\arguments{
\item{Y}{data}

\item{I}{event indicator}

\item{X}{design matrix}

\item{Y_0}{historical data, default is NULL}

\item{I_0}{historical event indicator, default is NULL}

\item{X_0}{historical design matrix, default is NULL}

\item{tuning_parameters}{list of "cprop_beta", "Jmax",
and "pi_b"}

\item{hyperparameters}{list containing the hyperparameters c("a_sigma",
"b_sigma", "clam_smooth", "phi").}

\item{lambda_hyperparameters}{contains two hyperparameters (a_lambda and b_lambda) used for
the update of lambda, default is c(0.01, 0.01)}

\item{iter}{number of iterations for MCMC sampler, excluding warmup, 
default is 2000}

\item{warmup_iter}{number of warmup iterations (burn-in) for MCMC sampler, 
default is 2000}

\item{refresh}{number of iterations between printed screen updates, 
default is 500}

\item{max_grid}{grid size for the smoothed baseline hazard, default is 2000}
}
\value{
list with values after each iteration for parameters: out_fixed (J, 
 mu, sigma2, beta), lambda, s, as well as tuning values of the total number 
 of accepts: lambda_move and beta_move. Also included is the out_slam which 
 contains the shrunk estimate of the baseline hazard.
}
\description{
An MCMC sampler for time-to-event data, without Bayesian Borrowing.
We obtain a flexible baseline hazard function by making the split points 
random within a piecewise exponential model and using a Gaussian Markov 
random field prior to smooth the baseline hazards. Only calls the sampler and
does not run any input checks. Best practice is to call BayesFBHborrow(), if the 
user is not familiar with the model at hand.
}
\examples{
set.seed(123)
# Load example data and set your hyper parameters
data(weibull_cc, package = "BayesFBHborrow")
data(weibull_hist, package = "BayesFBHborrow")

# The datasets consists of 3 (2) columns named "tte", "event" and "X".
# To explicitly run the sampler, extract the samples as following
Y <- weibull_cc$tte
I <- weibull_cc$event
X <- matrix(weibull_cc$X_trt)

# Specify hyperparameters and tuning parameters
hyper <-  list("a_sigma" = 2,
               "b_sigma" = 2,
               "clam_smooth" = 0.5,
               "phi" = 3)

tuning_parameters <- list("Jmax" = 5,
                          "pi_b" = 0.5,
                          "cprop_beta" = 0.5)
                          
# Set initial values to 'NULL' for default settings
output <- GibbsMH(Y, I, X, NULL, NULL, NULL,
                  tuning_parameters = tuning_parameters, hyperparameters = hyper, 
                  iter = 5, warmup_iter = 1)
}
