% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Normal}
\alias{Normal}
\title{Create a Normal Prior}
\usage{
Normal(mu = 0, sigma = 1)
}
\arguments{
\item{mu}{Mean}

\item{sigma}{Standard Deviation}
}
\value{
see \code{\link{Gamma}}
}
\description{
Creates a Normal prior in Julia using Distributions.jl. This can
then be truncated using \code{\link{Truncated}} to obtain a prior
that could then be used as a variance prior.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Truncated(Normal(0, 0.5), 0, Inf))
}

}
