% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior.mixturescale}
\alias{prior.mixturescale}
\title{Scale Mixture of Gaussian Prior}
\usage{
prior.mixturescale(chain, sigma1, sigma2, pi1)
}
\arguments{
\item{chain}{Chain obtained using \code{\link{Chain}}}

\item{sigma1}{Standard deviation of first Gaussian}

\item{sigma2}{Standard deviation of second Gaussian}

\item{pi1}{Weight of first Gaussian}
}
\value{
a list containing the following
\itemize{
    \item `juliavar` the julia variable used to store the prior
    \item `juliacode` the julia code
}
}
\description{
Uses a scale mixture of Gaussian for each network parameter. That is,
the prior is given by
\deqn{\pi_1 Normal(0, sigma1) + (1-\pi_1) Normal(0, sigma2)}
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.mixturescale(net, 10, 0.1, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sampler <- sampler.SGLD()
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
