% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter-stepsize.R
\name{sadapter.Const}
\alias{sadapter.Const}
\title{Use a constant stepsize in mcmc}
\usage{
sadapter.Const(l)
}
\arguments{
\item{l}{stepsize}
}
\value{
list with `juliavar`, `juliacode` and the given arguments
}
\description{
Use a constant stepsize in mcmc
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sadapter <- sadapter.Const(1e-5)
  sampler <- sampler.GGMC(sadapter = sadapter)
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
