% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{sampler.GGMC}
\alias{sampler.GGMC}
\title{Gradient Guided Monte Carlo}
\usage{
sampler.GGMC(
  beta = 0.1,
  l = 1,
  sadapter = sadapter.DualAverage(1000),
  madapter = madapter.FixedMassMatrix(),
  steps = 3
)
}
\arguments{
\item{beta}{See paper}

\item{l}{stepsize}

\item{sadapter}{Stepsize adapter; Not used in original paper}

\item{madapter}{Mass adapter; Not used in ogirinal paper}

\item{steps}{Number of steps before accept/reject}
}
\value{
a list with `juliavar`, `juliacode` and all provided arguments.
}
\description{
Proposed in Garriga-Alonso, A., & Fortuin, V. (2021). Exact langevin dynamics
with stochastic gradients. arXiv preprint arXiv:2102.01691.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sadapter <- sadapter.DualAverage(100)
  sampler <- sampler.GGMC(sadapter = sadapter)
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
