% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.eigen.value}
\alias{GP.eigen.value}
\title{Compute eigen values for the standard modified exponential squared correlation kernel.}
\usage{
GP.eigen.value(poly_degree = 10, a = 1, b = 1, d = 2)
}
\arguments{
\item{poly_degree}{A positive integer number specifies the highest degree of Hermite polynomials. The default value is 10L.}

\item{a}{A positive real number specifying the concentration parameter in the modified exponetial squared kernel. The larger value the more the GP concentrates around the center. The default value is 0.01.}

\item{b}{A positive real number specifying the smoothness parameter in the modeified exponetial squared kernel. The smaller value the smoother the GP is. The default value is 1.0.}

\item{d}{A positive integer number specifying the dimension of grid points.}
}
\value{
A matrix represents a set of eigen functions evaluated at grid points.
The number of rows is equal to the number of grid points. The number of columns is choose(poly_degree+d,d), where d is the dimnension of the grid points.
}
\description{
Compute eigen values for the standard modified exponential squared correlation kernel.
}
\details{
Compute eigen values of the standard modified exponential squared kernel on d-dimensional grids

\eqn{cor(X(s_1),X(s_2)) = \exp{-a*(s_1^2+*s_2^2)-b*(s_1-s_2)^2}}

where \eqn{a} is the concentration parameter and \eqn{b} is the smoothness parameter. The expected ranges of each coordinate is from -6 to 6.
}
\examples{
library(BayesGPfit)
Lambda = GP.eigen.value(poly_degree=10L,a=0.01,b=0.5,d=2)
plot(Lambda)

}
\author{
Jian Kang <jiankang@umich.edu>
}
