% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kd_filter.R
\name{kd.filter}
\alias{kd.filter}
\title{Kalman Filter with Drift}
\usage{
kd.filter(y, m0, C0, V, W, Ft, Gt, a1, a2)
}
\arguments{
\item{y}{Observed data as an m-by-N matrix where m is the dimension}

\item{m0}{Initial mean as a p-vector}

\item{C0}{Initial covariance p-by-p matrix}

\item{V}{Covariance m-by-p matrix V referring to observation error}

\item{W}{Covariance p-by-p matrix W referring to system error}

\item{Ft}{Constant observation matrix as an m-by-p matrix}

\item{Gt}{Constant evolution matrix as a p-by-p matrix}

\item{a1}{Drift of the observational equation}

\item{a2}{Drift of the system equation}
}
\value{
A list containing the means \code{m} and the covariances \code{C}
}
\description{
Computes mean and variance of the distribution of the state, conditional
on the covariances of observation and system errors, evolution matrices, drifts
and the observations up to that point.
}
\note{
Reference: Petris et al, 2009, p.53
}
