% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_dlm.R
\name{predict.DLM}
\alias{predict.DLM}
\title{DLM: Prediction of death probability}
\usage{
\method{predict}{DLM}(object, h, prob = 0.95, ...)
}
\arguments{
\item{object}{A \code{DLM} object that is result of a call to dlm() function.}

\item{h}{The ages prediction horizon.}

\item{prob}{Coverage probability of the predictive intervals.}

\item{...}{Other arguments.}
}
\value{
A data.frame with the death probability prediction and prediction interval for the ages in the prediction horizon.
}
\description{
Extrapolates the mortality curve fitted by DLM by calculating the median
of death probability and the respective prediction interval.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the log mortality rate of the year 2000, ranging from 0 to 100 years old:
USA2000 = USA[USA$Year == 2000,]
x = 0:100
Ex = USA2000$Ex.Total[x+1]
Dx = USA2000$Dx.Total[x+1]

y = log(Dx/Ex)

## Fitting dlm
fit = dlm(y, M = 100)

## Extrapolating the death probabilities (qx)
predict(fit, h = 3, prob = 0.95)


}
\seealso{
\code{\link[=fitted.DLM]{fitted.DLM()}}.
}
