% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bvs.R
\name{summary.Bvs}
\alias{summary.Bvs}
\title{Summary of an object of class \code{Bvs}}
\usage{
\method{summary}{Bvs}(object, ...)
}
\arguments{
\item{object}{An object of class \code{Bvs}}

\item{...}{Additional parameters to be passed}
}
\description{
Summary of an object of class \code{Bvs}, providing inclusion probabilities and a representation of
the Median Probability Model and the Highest Posterior probability Model.
}
\examples{

\dontrun{
#Analysis of Crime Data
#load data
data(UScrime)

#Default arguments are Robust prior for the regression parameters
#and constant prior over the model space
#Here we keep the 1000 most probable models a posteriori:
crime.Bvs<- Bvs(formula= y ~ ., data=UScrime, n.keep=1000)

#A look at the results:
summary(crime.Bvs)
}

}
\seealso{
See \code{\link[BayesVarSel]{Bvs}},
  \code{\link[BayesVarSel]{GibbsBvs}} for creating objects of the class
  \code{Bvs}.
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

  Maintainer: <anabel.forte@uv.es>
}
