% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPV_heatmap.R
\name{PPV_heatmap}
\alias{PPV_heatmap}
\title{Plot PPV and NPV heatmaps}
\usage{
PPV_heatmap(
  Min_Prevalence = 1,
  Max_Prevalence = 1000,
  Sensitivity = 95,
  Min_FP = 0,
  Max_FP = 10,
  overlay = "no",
  overlay_labels = "",
  overlay_position_FP = 1,
  overlay_position_FN = 1,
  overlay_prevalence_1 = 1,
  overlay_prevalence_2 = 100,
  uncertainty_prevalence = "high",
  label_title = "",
  label_subtitle = "",
  Language = "en",
  folder = "",
  PPV_NPV = "PPV",
  DEBUG = 0
)
}
\arguments{
\item{Min_Prevalence}{x in the "x out of y" prevalence (y-axis): [1-Inf]}

\item{Max_Prevalence}{y in the "x out of y" prevalence (y-axis): [1-Inf]}

\item{Sensitivity}{Sensitivity of the test: [0-100]}

\item{Min_FP}{Minimum False Positives ratio to show in plot (x-axis): [1-100]}

\item{Max_FP}{Maximum False Positives ratio to show in plot (x-axis): [1-100]}

\item{overlay}{Show overlay: [TRUE, FALSE]}

\item{overlay_labels}{Labels for each point in the overlay. For example: c("80", "70", "60", "50", "40", "30", "20  y.o.")}

\item{overlay_position_FP}{FP value (position in the x-axis) for each point in the overlay. For example: c(7, 8, 9, 12, 14, 14)}

\item{overlay_position_FN}{FN value (position in the x-axis) for each point in the overlay. For example: c(7, 8, 9, 12, 14, 14)}

\item{overlay_prevalence_1}{Prevalence value (position in the y-axis) for each point in the overlay. For example: c(1, 1, 1, 2, 1, 1)}

\item{overlay_prevalence_2}{Prevalence value (position in the y-axis) for each point in the overlay. For example: c(26, 29, 44, 69, 227, 1667)}

\item{uncertainty_prevalence}{How much certainty we have about the prevalence ["high"/"low"]}

\item{label_title}{Title for the plot}

\item{label_subtitle}{Subtitle for the plot}

\item{Language}{Language for the plot labels: ["sp", "en"]}

\item{folder}{Where to save the plot (the filename would be automatically created using the plot parameters)}

\item{PPV_NPV}{Should show PPV or NPV [PPV/NPV]}

\item{DEBUG}{Shows debug warnings [0/1]}
}
\value{
Shows a plot or, if given a folder argument, saves a .png version of the plot
}
\description{
Plot heatmaps showing the PPV for a given Sensitivity and a range of Prevalences and False Positive values or NPV values for a given Specificity and a range of Prevalences and True Positive values
}
\examples{
PPV_heatmap(Min_Prevalence = 1, 
Max_Prevalence = 1000, 
Sensitivity = 100, 
Max_FP = 2, 
Language = "en")
}
