% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.slice_clouds.R
\name{plot.slice_clouds}
\alias{plot.slice_clouds}
\title{Plots of Bclim slice clouds}
\usage{
\method{plot}{slice_clouds}(x, slice = 1, dims = 1:2, n = 50, ...)
}
\arguments{
\item{x}{The output of a run from \code{\link{slice_clouds}}}

\item{slice}{The chosen slice to plot}

\item{dims}{A vector of length 2. dim=1 corresponds to GDD5, dim=2 to MTCO, and dim=3 to AET/PET}

\item{n}{The resolution of the resulting plot. A higher value of n will yield finer plots but might require some colour adjustment}

\item{...}{Other arguments to the plot function such as axis labels, titles, and colours}
}
\value{
Just a plot
}
\description{
Create bivariate climate plots of individual slices. For examples why not see the wonderful Bclim vignette (available at https://cran.r-project.org/web/packages/Bclim/index.html) and the author's personal webpage (https://maths.ucd.ie/parnell)?
}
\details{
This function creates a bivariate density plot of two climate dimensions (two of GDD5, MTCO and AET/PET) using the MASS library function \code{\link{kde2d}}
}
\seealso{
The main Bclim functions are \code{\link{slice_clouds}} and \code{\link{climate_histories}}
}

