% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bergm.output.R
\name{bergm.output}
\alias{bergm.output}
\title{Summarising posterior BERGM output}
\usage{
bergm.output(x, ...)
}
\arguments{
\item{x}{an \code{R} object of class \code{bergm} 
or \code{calibrate.bergm}}

\item{...}{additional arguments, to be passed to lower-level functions.}
}
\description{
This function returns the posterior parameter density estimate 
and creates simple diagnostic plots for the MCMC produced from a fit.
}
\examples{
# Load the florentine marriage network
data(florentine)

# Posterior parameter estimation:

p.flo <- bergm(flomarriage ~ edges + kstar(2),
               burn.in = 50,
               aux.iters = 500,
               main.iters = 500,
               gamma = 1)

# MCMC diagnostics and posterior summaries:

bergm.output(p.flo)

}
